---
generated_at: 2026-02-03 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：28-Worker Overview（ワーカー概要）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **WorkerStateResponseのフィールド一覧**：DeployMessages.scalaを直接読んでいないため推定

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/deploy/worker/ui/WorkerPage.scala`（227行）
- E-02: `core/src/main/scala/org/apache/spark/deploy/worker/ui/WorkerWebUI.scala`（58行）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLはWorkerWebUIのルート `/` | E-01 (34行目: `WebUIPage("")`), E-02 (47行目: `attachPage(new WorkerPage(this))`) | ○ |
| C-02 | WorkerStateResponseをRPCで取得 | E-01 (57行目: `workerEndpoint.askSync[WorkerStateResponse](RequestWorkerState)`) | ○ |
| C-03 | JSON APIをrenderJsonで提供 | E-01 (37-39行目: `renderJson`) | ○ |
| C-04 | ワーカー基本情報にID, Master URL, Cores, Memory, Resourcesを表示 | E-01 (83-99行目) | ○ |
| C-05 | ワーカーIDにログページへのリンク付き | E-01 (87行目: `<a href={s"$workerUrlRef/logPage/?self&logType=out"}>`) | ○ |
| C-06 | Back to Masterリンク | E-01 (98行目: `<a href={workerState.masterWebUiUrl}>Back to Master</a>`) | ○ |
| C-07 | Running Executorsテーブルのカラム: ExecutorID, State, Cores, Memory, Resources, Job Details, Logs | E-01 (59-60行目) | ○ |
| C-08 | Running Driversテーブルのカラム: DriverID, Main Class, State, Cores, Memory, Resources, Logs, Notes | E-01 (68-69行目) | ○ |
| C-09 | Running Driversは存在する場合のみ表示 | E-01 (115行目: `if (runningDrivers.nonEmpty)`) | ○ |
| C-10 | Finished Executorsは存在する場合のみ表示 | E-01 (130行目: `if (finishedExecutors.nonEmpty)`) | ○ |
| C-11 | Finished Driversは存在する場合のみ表示 | E-01 (145行目: `if (finishedDrivers.nonEmpty)`) | ○ |
| C-12 | ドライバーIDは降順ソート | E-01 (70行目: `sortBy(_.driverId).reverse`) | ○ |
| C-13 | エグゼキュータのJob Details列にアプリID・名前・ユーザー表示 | E-01 (179-192行目) | ○ |
| C-14 | アプリ名リンクはRUNNING状態かつappUiUrl設定時のみ | E-01 (184行目: `if ({executor.state == ExecutorState.RUNNING} && executor.appDesc.appUiUrl.nonEmpty)`) | ○ |
| C-15 | ドライバーのStateはfinalState.getOrElse(RUNNING) | E-01 (209行目: `driver.finalState.getOrElse(DriverState.RUNNING)`) | ○ |
| C-16 | ドライバーのNotesはfinalException | E-01 (222行目: `driver.finalException.getOrElse("")`) | ○ |
| C-17 | ページタイトルは"Spark Worker at {host}:{port}" | E-01 (161-162行目) | ○ |
| C-18 | WorkerStateResponseのフィールド一覧 | **根拠なし**（DeployMessages.scalaを直接読んでいない） | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: WorkerStateResponseの正確なフィールド一覧はDeployMessages.scalaの確認が必要。ただしWorkerPage.scalaの使用箇所から推定可能
  - 候補：core/src/main/scala/org/apache/spark/deploy/DeployMessages.scala

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - WorkerPage.scalaの直接読み込みにより大部分の主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] WorkerStateResponseのフィールドが正確か確認
- [ ] ExecutorRunnerの状態とログパスの関係が正しいか確認
- [ ] reverseProxy時のURLパス生成が正しいか確認
